from sklearn.model_selection import RandomizedSearchCV, KFold
from sklearn.linear_model import LogisticRegression
from sklearn.metrics import accuracy_score, make_scorer
from pathlib import Path

def write_hpValues(model_Name, HP_Values,dataset):
    Path("results/%s" % dataset).mkdir(parents=True, exist_ok=True)
    Path("results/%s/%s" % (dataset,model_Name)).mkdir(parents=True, exist_ok=True)
    file_name = r'results/%s/%s/BestParam.txt' % (dataset,model_Name)
    with open(file_name, 'a+') as x_file:
        x_file.write(str(HP_Values))
        x_file.write("\n----------------------------------------------------------")
    return 0


# parameters grid to select the best combination using the listed values
def LogisticRegression_hyperparameterTuning(X_train, Y_train,dataset):
    grid_Param={'C': [0.001,0.01,0.1,1,10,30, 50,90,100,500,1000],
                'penalty':['l2','l1','elasticnet'],
                'solver':['newton-cg','lbfgs','liblinear','sag','saga']
                }


    kfold = KFold(n_splits=5, shuffle=True, random_state=42)

    LogisticReg = LogisticRegression()
    grid_search = RandomizedSearchCV(estimator= LogisticReg, param_distributions=grid_Param, n_iter=100, cv=kfold, verbose=2, scoring='accuracy',error_score=0, random_state=42, n_jobs=-1)
    grid_search.fit(X_train, Y_train)
    best_grid = grid_search.best_estimator_
    write_hpValues('LogisticRegression', str(best_grid),dataset)

    print(grid_search.best_estimator_)
    return grid_search


def LogisticRegression_training_tuning(X_train,Y_train,dataset):

    best_random = LogisticRegression_hyperparameterTuning(X_train,Y_train,dataset)
    Trained_model = LogisticRegression(**best_random.best_params_)
    Trained_model.fit(X_train,Y_train)
    return Trained_model
